import { EventHandler, EventHandlerRequest, defineEventHandler, getCookie } from 'h3'
import jwt from 'jsonwebtoken'

// 确保 openapi 请求的token是正确的，未过期的， 同时将当前登录用户信息注入请求上下文
export const defineAuthHandler = <T extends EventHandlerRequest, D>(
  handler: EventHandler<T, D>,
): EventHandler<T, D> =>
  //@ts-ignore
  defineEventHandler(async event => {
    const { prisma } = event.context
    // 获取当前cookie
    const authToken = getCookie(event, 'authToken')
    if (!authToken) {
      throw createError({
        statusCode: 403,
        message: '未携带cookie'
      });
    }

    const decodeToken = jwt.decode(authToken)

    // 获取当前请求的用户信息
    const user = await prisma.user.findUnique({
      where: {
        id: decodeToken.user_id
      }
    })

    if (!user) {
      throw createError({
        statusCode: 403,
        message: '未找到授权用户信息'
      });
    }

    // 检查用户的token是否过期
    if (Date.now() / 1000 > (user?.expires_at || 0)) {
      throw createError({
        statusCode: 403,
        message: '授权已过期'
      });
    }

    // 记录user到请求上下文
    event.context.user = user

    const response = await handler(event)
    return { ...response }
  })