import { deleteCookie, getCookie } from 'h3'
import jwt from 'jsonwebtoken'
import { useRuntimeConfig } from '#imports'

// 处理用户登出， 并通知认证服务也登出
export default defineEventHandler(async (event) => {
  const config = useRuntimeConfig()
  const { prisma } = event.context

  // 获取当前cookie
  const authToken = getCookie(event, 'authToken')
  if (authToken) {
    const decodeToken = jwt.decode(authToken)

    // 获取用户的 id_token 信息，用于重定向到认证服务
    const user = await prisma.user.findUnique({
      where: {
        id: decodeToken.user_id
      },
      select: {
        id_token: true
      }
    })

    // 清理登录cookie
    deleteCookie(event, 'authToken', {
      path: '/'
    })

    // 清空当前用户授权信息
    await event.context.prisma.user.update({
      where: {
        id: decodeToken.user_id
      },
      data: {
        expires_at: 0,
        refresh_token: '',
        access_token: '',
        id_token: '',
      }
    })

    const callback = config.oauth.postLogoutRedirectUri

    if (user?.id_token) {
      // 重定向到认证服务，通知认证服务登出
      return await sendRedirect(event, `${config.oauth.endpoint}/oauth/session/end?id_token_hint=${user.id_token}&post_logout_redirect_uri=${encodeURIComponent(callback)}`, 302)
    } else {
      return await sendRedirect(event, "/")
    }
  }
})