import { H3Event, sendRedirect } from 'h3'

import { createOAuthState } from '~/server/utils/state'

export default defineEventHandler(async (event: H3Event) => {
  const config = useRuntimeConfig()
  const { oauth } = config
  const state = await createOAuthState(event)
  const path = `${oauth.endpoint}/oauth/authorize?response_type=code&scope=openid%20profile%20email&client_id=${oauth.clientId}&state=${state}&redirect_uri=${encodeURIComponent(oauth.redirectUri)}`
  return await sendRedirect(event, path)
})