import { H3Event } from 'h3'
import jwt from 'jsonwebtoken'

// 接收认证服务登出通知，处理当前应用的登录态
export default defineEventHandler(async (event: H3Event) => {
  const data = await readBody(event)
  console.log('收到登出回调通知', data)
  const { logoutToken } = data

  if (logoutToken) {
    const decodeLogoutToken = jwt.decode(logoutToken)
    if (decodeLogoutToken) {
      const user = await event.context.prisma.user.findFirst({
        where: {
          user_id: decodeLogoutToken.sub
        }
      })

      if (user) {
        // 清空授权信息
        await event.context.prisma.user.update({
          where: {
            user_id: decodeLogoutToken.sub
          },
          data: {
            expires_at: 0,
            refresh_token: '',
            access_token: '',
            id_token: '',
          }
        })

        // 清理登录cookie
        deleteCookie(event, 'authToken', {
          path: '/'
        })

        console.log('登出执行完毕')
      }
    }
  }
})