const fs = require('fs')

const updatePackage = () => {
  const targetPackagePath = './.output/server/package.json'
  const data = fs.readFileSync(targetPackagePath, 'utf8');
  const config = JSON.parse(data);

  if (config && config.prisma && config.prisma.seed) {
    console.log('prisma.prisma配置项存在, 是：', config.prisma.seed)
    return
  }

  config.prisma = config.prisma || {}
  config.prisma.seed = 'node node_modules/.prisma/client/seed.js'

  // 增加脚本
  config.scripts = config.scripts || {}
  // 增加数据结构更新脚本
  config.scripts.migrate = 'npx prisma migrate deploy --schema node_modules/.prisma/client/schema.prisma'

  try {
    fs.writeFileSync(targetPackagePath, JSON.stringify(config, null, 2));
    console.log("prisma.prisma配置项已保存.");
  } catch (error) {
    console.error(err);
  }
}

updatePackage()