// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  app: {
    head: {
      htmlAttrs: {
        lang: 'zh-CN',
      },
      title: '单点登录之Nuxt3例子',
      meta: [
        { name: 'charset', content: 'UTF-8' },
        { name: 'viewport', content: 'width=device-width, initial-scale=1.0' },
        {
          hid: 'description',
          name: 'description',
          content: '',
        },
      ]
    }
  },
  runtimeConfig: {
    // oauth配置
    oauth: {
      endpoint: '',
      clientId: '',
      clientSecret: '',
      redirectUri: '',
      postLogoutRedirectUri: ''
    },
    // jwt配置
    jwt: {
      secret: '',
      ttl: 60 * 60,
    }
  },
  modules: [
    '@nuxtjs/tailwindcss',
    '@tdesign-vue-next/nuxt'
  ],
  typescript: {
    shim: false
  },
  // sourcemap: {
  //   "server": false,
  //   "client": false
  // },
  css: [
    // './assets/css/main.css',
  ],
})
