# sso-client-nuxt3-example

单点登录客户端之nux3实现示例。


## 目录结构

```
├── app.vue 应用根组件
├── eslint.config.js
├── index.d.ts
├── nuxt.config.ts nuxt应用配置文件
├── package.json
├── pages 页面
│   └── index.vue 应用首页
├── pnpm-lock.yaml
├── prisma
│   ├── db.sqlite 当前数据库
│   ├── schema.prisma 当前数据库设计定义
├── README.md
├── server 服务端
│   ├── api
│   │   ├── sso 单点登录
│   │   │   ├── cb.get.ts 单点登录成功的回调处理接口
│   │   │   └── login.get.ts 单点登录处理接口
|   |   |   └── logout.get.ts 主动登出处理接口
|   |   |   └── listen.post.ts 被动登出处理接口
|   |   |── protected.ts 受权限保护的接口示例，确保token是合法未过期的
│   ├── middleware 服务端路由中间件
│   │   └── 0.prisma.ts 注册prisma实例
│   ├── tsconfig.json
│   └── utils 通用函数
│       ├── state.ts state参数通用处理
│       └── string.ts 字符串通用处理
|       └── auth.handler.ts 验证token合法的中间件handler, 可灵活为不同的api端点设置保护，见 server/api/protected.ts 示例
└── tsconfig.json
```

## 依赖

- node.js v20.17.0
- pnpm v8.6.9

## 初始化

生成配置文件，并填入相关配置信息

```shell
cp .env.example .env
```

安装依赖

```shell
pnpm i
```

迁移数据表

```shell
npx prisma migrate reset
```

启动服务

```shell
pnpm dev 
```

访问： http://127.0.0.1:3000
